#include "stdafx.h"
#include "pack_json.h"
#include "cJSON.h"

void pack_json_av_stream(jy_av_stream_t *p_av_stream, char **p_param)
{
	if ((NULL == p_param) || (NULL == p_av_stream))
	{
		return;
	}

	*p_param = NULL;
	cJSON *p_json_root = cJSON_CreateObject();
	cJSON_AddNumberToObject(p_json_root, "chn", p_av_stream->channel_id);
	cJSON_AddNumberToObject(p_json_root, "stream", p_av_stream->stream_id);
	cJSON_AddNumberToObject(p_json_root, "width", p_av_stream->video_width);
	cJSON_AddNumberToObject(p_json_root, "height", p_av_stream->video_height);
	cJSON_AddNumberToObject(p_json_root, "v_enc", p_av_stream->video_encoder_type);
	cJSON_AddNumberToObject(p_json_root, "fps", p_av_stream->frame_rate);
	cJSON_AddNumberToObject(p_json_root, "bps", p_av_stream->bit_rate);
	cJSON_AddNumberToObject(p_json_root, "if_int", p_av_stream->i_frame_interval);
	cJSON_AddNumberToObject(p_json_root, "quality", p_av_stream->quality);
	cJSON_AddNumberToObject(p_json_root, "bit_type", p_av_stream->bit_rate_type);
	cJSON_AddNumberToObject(p_json_root, "v_enc_level", p_av_stream->video_encode_level);
	cJSON_AddNumberToObject(p_json_root, "i_unit", p_av_stream->i_frame_interval_unit);
	cJSON_AddNumberToObject(p_json_root, "a_enc", p_av_stream->audio_encoder_type);
	cJSON_AddStringToObject(p_json_root, "streamname", p_av_stream->stream_name);

	*p_param = cJSON_PrintUnformatted(p_json_root);
	cJSON_Delete(p_json_root);
}

void pack_json_open_snap(jy_snap_picture_t *p_snap_picture, char **p_param)
{
	if ((NULL == p_param) || (NULL == p_snap_picture))
	{
		return;
	}

	*p_param = NULL;
	cJSON *p_json_root = cJSON_CreateObject();
	cJSON_AddNumberToObject(p_json_root, "chn", p_snap_picture->channel_id);
	cJSON_AddNumberToObject(p_json_root, "timeout", p_snap_picture->time_out);
	cJSON_AddNumberToObject(p_json_root, "quality", p_snap_picture->quality);

	*p_param = cJSON_PrintUnformatted(p_json_root);
	cJSON_Delete(p_json_root);
}

void pack_json_snap_picture(jy_snap_picture_t *p_snap_picture, char **p_param)
{
	if ((NULL == p_param) || (NULL == p_snap_picture))
	{
		return;
	}

	*p_param = NULL;
	cJSON *p_json_root = cJSON_CreateObject();
	cJSON_AddNumberToObject(p_json_root, "chn", p_snap_picture->channel_id);
	cJSON_AddNumberToObject(p_json_root, "timeout", p_snap_picture->time_out);
	cJSON_AddNumberToObject(p_json_root, "quality", p_snap_picture->quality);
	cJSON_AddStringToObject(p_json_root, "path", p_snap_picture->path);

	*p_param = cJSON_PrintUnformatted(p_json_root);
	cJSON_Delete(p_json_root);
}

void pack_json_osd_param(jy_dev_osd_user_param_t *p_osd_param, char **p_param)
{
	*p_param = NULL;
	cJSON *p_json_root = cJSON_CreateObject();

	cJSON* p_osd_user_param = cJSON_CreateObject();
	cJSON_AddItemToObject(p_json_root, "OSDUserParam", p_osd_user_param);
	cJSON_AddNumberToObject(p_osd_user_param, "CameraId", p_osd_param->camera_id);
	cJSON* p_osd_global_param = cJSON_CreateObject();
	cJSON_AddItemToObject(p_osd_user_param, "OSDGlobalParam", p_osd_global_param);
	cJSON_AddNumberToObject(p_osd_global_param, "TimeFormatID", p_osd_param->osd_global_param.time_format_id);
	cJSON_AddNumberToObject(p_osd_global_param, "OSDFontAlpha", p_osd_param->osd_global_param.osd_font_alpha);
	if (p_osd_param->osd_global_param.inverse_flag)
	{
		cJSON_AddBoolToObject(p_osd_global_param, "InverseFlag", 1);
	}
	else
	{
		cJSON_AddBoolToObject(p_osd_global_param, "InverseFlag", 0);
	}
	cJSON_AddNumberToObject(p_osd_global_param, "ChannelId", p_osd_param->osd_global_param.channel_id);
	cJSON_AddNumberToObject(p_osd_global_param, "TwelveHoursFlag", p_osd_param->osd_global_param.twelve_hours_flag);
	cJSON_AddNumberToObject(p_osd_global_param, "WeekFlag", p_osd_param->osd_global_param.week_flag);
	cJSON* p_osd_font_color = cJSON_CreateObject();
	cJSON_AddItemToObject(p_osd_global_param, "OSDFontColor", p_osd_font_color);
	cJSON_AddNumberToObject(p_osd_font_color, "R", p_osd_param->osd_global_param.font_color.n_r);
	cJSON_AddNumberToObject(p_osd_font_color, "G", p_osd_param->osd_global_param.font_color.n_g);
	cJSON_AddNumberToObject(p_osd_font_color, "B", p_osd_param->osd_global_param.font_color.n_b);
	cJSON* p_inverse_color = cJSON_CreateObject();
	cJSON_AddItemToObject(p_osd_global_param, "OSDFontInverseColor", p_inverse_color);
	cJSON_AddNumberToObject(p_inverse_color, "R", p_osd_param->osd_global_param.font_inverse_color.n_r);
	cJSON_AddNumberToObject(p_inverse_color, "G", p_osd_param->osd_global_param.font_inverse_color.n_g);
	cJSON_AddNumberToObject(p_inverse_color, "B", p_osd_param->osd_global_param.font_inverse_color.n_b);
	cJSON *p_canvas_proper_list = cJSON_CreateArray();
	cJSON_AddItemToObject(p_osd_user_param, "CanvasProperList", p_canvas_proper_list);
	for (int i = 0; i < p_osd_param->canvas_proper_num; ++i)
	{
		cJSON *p_canvas_proper = cJSON_CreateObject();
		cJSON_AddItemToArray(p_canvas_proper_list, p_canvas_proper);
		cJSON_AddNumberToObject(p_canvas_proper, "FrontWidth", p_osd_param->canvas_proper_list[i].front_width);
		cJSON_AddNumberToObject(p_canvas_proper, "FrontHeight", p_osd_param->canvas_proper_list[i].front_height);
		cJSON_AddNumberToObject(p_canvas_proper, "AlignMode", p_osd_param->canvas_proper_list[i].align_mode);
		cJSON_AddNumberToObject(p_canvas_proper, "AreaID", p_osd_param->canvas_proper_list[i].area_id);
		cJSON* p_area_param = cJSON_CreateObject();
		cJSON_AddItemToObject(p_canvas_proper, "AreaParam", p_area_param);
		cJSON_AddNumberToObject(p_area_param, "TopX", p_osd_param->canvas_proper_list[i].area_param.top_x);
		cJSON_AddNumberToObject(p_area_param, "TopY", p_osd_param->canvas_proper_list[i].area_param.top_y);
		cJSON_AddNumberToObject(p_area_param, "Width", p_osd_param->canvas_proper_list[i].area_param.width);
		cJSON_AddNumberToObject(p_area_param, "Height", p_osd_param->canvas_proper_list[i].area_param.height);
		cJSON *p_osd_info_list = cJSON_CreateArray();
		cJSON_AddItemToObject(p_canvas_proper, "OSDInfoList", p_osd_info_list);
		for (int j = 0; j < p_osd_param->canvas_proper_list[i].osd_info_list_num; ++j)
		{
			cJSON *p_osd_info = cJSON_CreateObject();
			cJSON_AddItemToArray(p_osd_info_list, p_osd_info);
			cJSON_AddNumberToObject(p_osd_info, "AreaID", p_osd_param->canvas_proper_list[i].osd_info[j].area_id);
			cJSON_AddNumberToObject(p_osd_info, "ArrowID", p_osd_param->canvas_proper_list[i].osd_info[j].arrow_id);
			cJSON_AddNumberToObject(p_osd_info, "Type", p_osd_param->canvas_proper_list[i].osd_info[j].type);
			if (p_osd_param->canvas_proper_list[i].osd_info[j].enable_flag)
				cJSON_AddBoolToObject(p_osd_info, "EnableFlag", 1);
			else
				cJSON_AddBoolToObject(p_osd_info, "EnableFlag", 0);
			cJSON_AddNumberToObject(p_osd_info, "ShowMode", p_osd_param->canvas_proper_list[i].osd_info[j].show_mode);
			cJSON_AddStringToObject(p_osd_info, "Info", p_osd_param->canvas_proper_list[i].osd_info[j].info);
		}
	}

	*p_param = cJSON_PrintUnformatted(p_json_root);
	cJSON_Delete(p_json_root);
}

void pack_json_net_param(jy_dev_net_param_list_t *p_net_param, char **p_param)
{
	if ((NULL == p_net_param) || (NULL == p_param))
	{
		return;
	}
	*p_param = NULL;
	cJSON *p_json_root = cJSON_CreateObject();
	cJSON *p_json_data = cJSON_CreateArray();
	cJSON_AddItemToObject(p_json_root, "data", p_json_data);
	for (int i = 0; i < p_net_param->size;i++)
	{
		cJSON* p_item = cJSON_CreateObject();
		cJSON_AddStringToObject(p_item, "ip", p_net_param->net_param[i].m_strLocalIp);
		cJSON_AddBoolToObject(p_item, "dhcp", p_net_param->net_param[i].m_bDHCP);
		cJSON_AddStringToObject(p_item, "netmask", p_net_param->net_param[i].m_strLocalSubnetMask);
		cJSON_AddStringToObject(p_item, "gw", p_net_param->net_param[i].m_strGateway);
		cJSON_AddStringToObject(p_item, "dns1", p_net_param->net_param[i].m_strPrimaryDNSIp);
		cJSON_AddStringToObject(p_item, "dns2", p_net_param->net_param[i].m_strSpareDNSIp);
		cJSON_AddNumberToObject(p_item, "netid", p_net_param->net_param[i].m_nNetId);
		cJSON_AddNumberToObject(p_item, "worktype", p_net_param->net_param[i].m_nWorkingType);
		int ip_ver = p_net_param->net_param[i].m_nIPProtoVer;
		char sz_ver[32] = { 0 };
		if (JY_IP_TYPE_VER_6 == ip_ver)
		{
			strncpy(sz_ver, "IPv6", sizeof(sz_ver) - 1);
		}
		else
		{
			strncpy(sz_ver, "IPv4", sizeof(sz_ver) - 1);
		}
		cJSON_AddStringToObject(p_item, "ip_proto", sz_ver);

		cJSON_AddItemToArray(p_json_data, p_item);
	}

	*p_param = cJSON_PrintUnformatted(p_json_root);
	cJSON_Delete(p_json_root);
}

void pack_json_port_param(jy_dev_port_t *p_port_param, char **p_param)
{
	if ((NULL == p_port_param) || (NULL == p_param))
	{
		return;
	}
	*p_param = NULL;
	cJSON *p_json_root = cJSON_CreateObject();
	cJSON_AddNumberToObject(p_json_root, "ControlPort", p_port_param->m_nControlPort);
	cJSON_AddNumberToObject(p_json_root, "TCPAVPort", p_port_param->m_nTCPAVPort);
	cJSON_AddNumberToObject(p_json_root, "RTSPPort", p_port_param->m_nRTSPPort);
	cJSON_AddNumberToObject(p_json_root, "RTPPort", p_port_param->m_nRTPPort);
	cJSON_AddNumberToObject(p_json_root, "RTCPPort", p_port_param->m_nRTCPPort);
	cJSON_AddNumberToObject(p_json_root, "RegisterPort", p_port_param->m_nRegisterPort);
	cJSON_AddNumberToObject(p_json_root, "HttpPort", p_port_param->m_nHttpPort);
	cJSON_AddNumberToObject(p_json_root, "ReservePort1", p_port_param->m_nReservePort1);
	cJSON_AddNumberToObject(p_json_root, "ReservePort2", p_port_param->m_nReservePort2);
	cJSON_AddNumberToObject(p_json_root, "ReservePort3", p_port_param->m_nReservePort3);
	cJSON_AddNumberToObject(p_json_root, "ReservePort4", p_port_param->m_nReservePort4);
	cJSON_AddNumberToObject(p_json_root, "SslControlPort", p_port_param->m_nSslControlPort);
	cJSON_AddNumberToObject(p_json_root, "HttpsPort", p_port_param->m_nHttpsPort);
	*p_param = cJSON_PrintUnformatted(p_json_root);
	cJSON_Delete(p_json_root);
}

void pack_json_ai_multi_object_detect_param(jy_dev_ai_multi_object_param_t *p_multi_param, char **p_param)
{
	if ((NULL == p_multi_param) || (NULL == p_param))
	{
		return;
	}
	*p_param = NULL;
	cJSON *p_json_root = cJSON_CreateObject();
	cJSON *p_root = cJSON_CreateObject();
	cJSON_AddBoolToObject(p_root, "FaceEnable", p_multi_param->face_enable);
	cJSON_AddBoolToObject(p_root, "UpBodyEnable", p_multi_param->upbody_enable);
	cJSON_AddBoolToObject(p_root, "FullBodyEnable", p_multi_param->fullbody_enable);
	cJSON_AddBoolToObject(p_root, "PlateEnable", p_multi_param->plate_enable);
	cJSON_AddBoolToObject(p_root, "VehicleEnable", p_multi_param->vehicle_enable);
	cJSON_AddNumberToObject(p_root, "PitchDegree", p_multi_param->pitch_degree);
	cJSON_AddNumberToObject(p_root, "YawDegree", p_multi_param->yaw_degree);
	cJSON_AddNumberToObject(p_root, "TiltDegree", p_multi_param->tilt_degree);
	cJSON_AddNumberToObject(p_root, "SnapPictureMode", p_multi_param->snap_picture_mode);
	cJSON_AddNumberToObject(p_root, "SnapPictureNum", p_multi_param->snap_picture_num);
	cJSON_AddNumberToObject(p_root, "ConsumePictrueMode", p_multi_param->consume_pictrue_mode);
	cJSON_AddBoolToObject(p_root, "ShowObjectEnable", p_multi_param->show_object_enable);
	cJSON_AddBoolToObject(p_root, "ShowAreaEnable", p_multi_param->show_area_enable);
	cJSON_AddBoolToObject(p_root, "FtpUploadEnable", p_multi_param->ftp_upload_enable);
	cJSON_AddBoolToObject(p_root, "FtpUploadFullViewEnable", p_multi_param->ftp_upload_full_enable);
	cJSON_AddNumberToObject(p_root, "UploadInterval", p_multi_param->upload_interval);
	cJSON_AddNumberToObject(p_root, "Reliability", p_multi_param->reliabilty);
	cJSON_AddNumberToObject(p_root, "FaceMinPixelWidth", p_multi_param->face_min_width);
	cJSON_AddNumberToObject(p_root, "FaceMaxPixelWidth", p_multi_param->face_max_width);
	cJSON_AddNumberToObject(p_root, "UpBodyMinPixelWidth", p_multi_param->upbody_min_width);
	cJSON_AddNumberToObject(p_root, "UpBodyMaxPixelWidth", p_multi_param->upbody_max_width);
	cJSON_AddNumberToObject(p_root, "FullBodyMinPixelWidth", p_multi_param->fullbody_min_width);
	cJSON_AddNumberToObject(p_root, "FullBodyMaxPixelWidth", p_multi_param->fullbody_max_width);
	cJSON_AddNumberToObject(p_root, "PlateMinPixelWidth", p_multi_param->plate_min_width);
	cJSON_AddNumberToObject(p_root, "PlateMaxPixelWidth", p_multi_param->plate_max_width);
	cJSON_AddNumberToObject(p_root, "VehicleMinPixelWidth", p_multi_param->vehicle_min_width);
	cJSON_AddNumberToObject(p_root, "VehicleMaxPixelWidth", p_multi_param->vehicle_max_width);
	cJSON_AddNumberToObject(p_root, "PictureQuality", p_multi_param->pic_quality);
	cJSON_AddBoolToObject(p_root, "AttrEnable", p_multi_param->attr_enable);
	cJSON_AddBoolToObject(p_root, "PictureOSDEnable", p_multi_param->pic_osd_enable);
	cJSON_AddBoolToObject(p_root, "LYFlag", p_multi_param->ly_flag);

	cJSON_AddNumberToObject(p_root, "ReferBrightness", p_multi_param->refer_brightness);
	cJSON_AddNumberToObject(p_root, "ContinueTime", p_multi_param->continue_time);
	cJSON_AddBoolToObject(p_root, "MaskCheckEnable", p_multi_param->mask_check_enable);
	cJSON_AddBoolToObject(p_root, "LiveDetectionEnable", p_multi_param->live_detection_enable);
	cJSON_AddBoolToObject(p_root, "FaceExposureEnable", p_multi_param->face_exposure_enable);
	cJSON_AddStringToObject(p_root, "AlgoVersion", p_multi_param->algo_version);

	cJSON *p_time_list = cJSON_CreateArray();
	for (int i = 0; i < p_multi_param->schedule_time_size; ++i)
	{
		cJSON *p_json_time = cJSON_CreateObject();
		cJSON_AddNumberToObject(p_json_time, "WeekDay", p_multi_param->schedule_time_list[i].week_day);
		cJSON_AddNumberToObject(p_json_time, "StartTime", p_multi_param->schedule_time_list[i].start_time);
		cJSON_AddNumberToObject(p_json_time, "EndTime", p_multi_param->schedule_time_list[i].end_time);
		cJSON_AddItemToArray(p_time_list, p_json_time);
	}
	cJSON_AddItemToObject(p_root, "ScheduleTimeList", p_time_list);

	cJSON *p_area_list = cJSON_CreateArray();
	for (int i = 0; i < p_multi_param->polygon_area_size; ++i)
	{
		cJSON *p_json_point = cJSON_CreateObject();
		cJSON_AddNumberToObject(p_json_point, "Xval", p_multi_param->polygon_area_list[i].x_val);
		cJSON_AddNumberToObject(p_json_point, "Yval", p_multi_param->polygon_area_list[i].y_val);
		cJSON_AddItemToArray(p_area_list, p_json_point);
	}
	cJSON_AddItemToObject(p_root, "PolygonAreaList", p_area_list);

	cJSON *p_area_param_list = cJSON_CreateArray();
	for (int i = 0; i < p_multi_param->polygon_area_param_size; ++i)
	{
		cJSON *p_json_polygonArea = cJSON_CreateObject();
		cJSON_AddNumberToObject(p_json_polygonArea, "FaceMinPixelWidth", p_multi_param->polygon_area_param_list[i].face_min_width);
		cJSON_AddNumberToObject(p_json_polygonArea, "FaceMaxPixelWidth", p_multi_param->polygon_area_param_list[i].face_max_width);
		cJSON_AddNumberToObject(p_json_polygonArea, "AreaId", p_multi_param->polygon_area_param_list[i].area_id);
		cJSON *p_point_list = cJSON_CreateArray();
		for (int j = 0; j < p_multi_param->polygon_area_param_list[i].polygon_area_size; ++j)
		{
			cJSON *p_json_point = cJSON_CreateObject();
			cJSON_AddNumberToObject(p_json_point, "Xval", p_multi_param->polygon_area_param_list[i].polygon_area_list[j].x_val);
			cJSON_AddNumberToObject(p_json_point, "Yval", p_multi_param->polygon_area_param_list[i].polygon_area_list[j].y_val);
			cJSON_AddItemToArray(p_point_list, p_json_point);
		}
		cJSON_AddItemToObject(p_json_polygonArea, "point_list", p_point_list);
		cJSON_AddItemToArray(p_area_param_list, p_json_polygonArea);

	}
	cJSON_AddItemToObject(p_root, "PolygonAreaParamList", p_area_param_list);

	cJSON *p_alarm_list = cJSON_CreateArray();
	for (int i = 0; i < p_multi_param->temp_alarm_deployment_size; ++i)
	{
		cJSON *p_json_alarm = cJSON_CreateObject();
		cJSON_AddNumberToObject(p_json_alarm, "SourceType", p_multi_param->temp_alarm_deployment_list[i].source_type);
		cJSON_AddNumberToObject(p_json_alarm, "SourceID", p_multi_param->temp_alarm_deployment_list[i].source_id);
		cJSON_AddNumberToObject(p_json_alarm, "AlarmRule", p_multi_param->temp_alarm_deployment_list[i].alarm_rule);
		cJSON_AddNumberToObject(p_json_alarm, "AlarmThreshold", p_multi_param->temp_alarm_deployment_list[i].alarm_threshold);
		cJSON_AddNumberToObject(p_json_alarm, "AlarmInterval", p_multi_param->temp_alarm_deployment_list[i].alarm_interval);

		cJSON *p_timeson_list = cJSON_CreateArray();
		for (int j = 0; j < p_multi_param->temp_alarm_deployment_list[i].schedule_time_size; ++j)
		{
			cJSON *p_json_time_son = cJSON_CreateObject();
			cJSON_AddNumberToObject(p_json_time_son, "WeekDay", p_multi_param->temp_alarm_deployment_list[i].schedule_time_list[j].week_day);
			cJSON_AddNumberToObject(p_json_time_son, "StartTime", p_multi_param->temp_alarm_deployment_list[i].schedule_time_list[j].start_time);
			cJSON_AddNumberToObject(p_json_time_son, "EndTime", p_multi_param->temp_alarm_deployment_list[i].schedule_time_list[j].end_time);
			cJSON_AddItemToArray(p_timeson_list, p_json_time_son);
		}
		cJSON_AddItemToObject(p_json_alarm, "ScheduleTimeList", p_timeson_list);

		cJSON *p_linkage_list = cJSON_CreateArray();
		for (int j = 0; j < p_multi_param->temp_alarm_deployment_list[i].alarm_linkage_size; ++j)
		{
			cJSON *p_json_linkage = cJSON_CreateObject();
			cJSON_AddNumberToObject(p_json_linkage, "ActionType", p_multi_param->temp_alarm_deployment_list[i].alarm_linkage_list[j].action_type);
			cJSON_AddNumberToObject(p_json_linkage, "ActionID", p_multi_param->temp_alarm_deployment_list[i].alarm_linkage_list[j].action_id);
			cJSON_AddItemToArray(p_linkage_list, p_json_linkage);
		}
		cJSON_AddItemToObject(p_json_alarm, "AlarmLinkageParamList", p_linkage_list);

		cJSON *p_out_list = cJSON_CreateArray();
		for (int j = 0; j < p_multi_param->temp_alarm_deployment_list[i].alarm_out_size; ++j)
		{
			cJSON *p_json_out = cJSON_CreateObject();
			cJSON_AddStringToObject(p_json_out, "DeviceId", p_multi_param->temp_alarm_deployment_list[i].alarm_out_list[j].device_id);
			cJSON_AddNumberToObject(p_json_out, "AlarmOutId", p_multi_param->temp_alarm_deployment_list[i].alarm_out_list[j].alarm_out_id);
			cJSON_AddNumberToObject(p_json_out, "AlarmOutFlag", p_multi_param->temp_alarm_deployment_list[i].alarm_out_list[j].alarm_out_flag);
			cJSON_AddNumberToObject(p_json_out, "EventTypeId", p_multi_param->temp_alarm_deployment_list[i].alarm_out_list[j].event_type_id);
			cJSON_AddNumberToObject(p_json_out, "AlarmTime", p_multi_param->temp_alarm_deployment_list[i].alarm_out_list[j].alarm_time);
			cJSON_AddItemToArray(p_out_list, p_json_out);
		}
		cJSON_AddItemToObject(p_json_alarm, "AlarmOutActionList", p_out_list);

		cJSON *p_record_list = cJSON_CreateArray();
		for (int j = 0; j < p_multi_param->temp_alarm_deployment_list[i].record_param_size; ++j)
		{
			cJSON *p_json_record = cJSON_CreateObject();
			cJSON_AddNumberToObject(p_json_record, "PreRecordFlag", p_multi_param->temp_alarm_deployment_list[i].record_param_list[j].pre_record_flag);
			cJSON_AddNumberToObject(p_json_record, "DelayRecordTime", p_multi_param->temp_alarm_deployment_list[i].record_param_list[j].delay_record_time);
			cJSON_AddItemToArray(p_record_list, p_json_record);
		}
		cJSON_AddItemToObject(p_json_alarm, "RecordActionParamList", p_record_list);

		cJSON *p_ptz_list = cJSON_CreateArray();
		for (int j = 0; j < p_multi_param->temp_alarm_deployment_list[i].ptz_action_size; ++j)
		{
			cJSON *p_json_ptz = cJSON_CreateObject();
			cJSON_AddNumberToObject(p_json_ptz, "PTZActionType", p_multi_param->temp_alarm_deployment_list[i].ptz_action_param_list[j].ptz_action_type);
			cJSON_AddNumberToObject(p_json_ptz, "PTZActionID", p_multi_param->temp_alarm_deployment_list[i].ptz_action_param_list[j].ptz_action_id);
			cJSON_AddNumberToObject(p_json_ptz, "PTZChannelID", p_multi_param->temp_alarm_deployment_list[i].ptz_action_param_list[j].ptz_chn_id);
			cJSON_AddItemToArray(p_ptz_list, p_json_ptz);
		}
		cJSON_AddItemToObject(p_json_alarm, "PTZActionParamList", p_ptz_list);

		cJSON_AddItemToArray(p_alarm_list, p_json_alarm);
	}
	cJSON_AddItemToObject(p_root, "TemperatureAlarmDeploymentList", p_alarm_list);

	cJSON_AddItemToObject(p_json_root, "AIMultiObjectDetectParam", p_root);
	*p_param = cJSON_PrintUnformatted(p_json_root);
	cJSON_Delete(p_json_root);
}

void pack_json_thermal_param(jy_dev_thermal_param_t *p_thermal_param, char **p_param)
{
	if ((NULL == p_thermal_param) || (NULL == p_param))
	{
		return;
	}
	*p_param = NULL;
	cJSON *p_json_root = cJSON_CreateObject();
	cJSON_AddNumberToObject(p_json_root, "is_open_tempera_measure", p_thermal_param->is_open_tempera_measure);
	cJSON_AddNumberToObject(p_json_root, "thermal_measure_mode", p_thermal_param->measure_mode);
	cJSON_AddNumberToObject(p_json_root, "cur_preset_id", p_thermal_param->cur_preset_id);
	cJSON_AddNumberToObject(p_json_root, "physics_info", p_thermal_param->physics_info);
	cJSON_AddNumberToObject(p_json_root, "area_feature_tempr_show_m", p_thermal_param->tempr_show_mode);
	cJSON_AddNumberToObject(p_json_root, "display_mode", p_thermal_param->display_mode);
	cJSON_AddNumberToObject(p_json_root, "osd_fontborder_enable", p_thermal_param->osd_fontborder_enable);
	cJSON_AddNumberToObject(p_json_root, "fontsize_mode", p_thermal_param->fontsize_mode);
	cJSON_AddNumberToObject(p_json_root, "custom_osd_colorEnable", p_thermal_param->custom_osd_color_enable);
	cJSON_AddNumberToObject(p_json_root, "facecolor_enable", p_thermal_param->facecolor_enable);
	cJSON_AddNumberToObject(p_json_root, "envit_temperature", p_thermal_param->envit_tempera);
	cJSON_AddNumberToObject(p_json_root, "cavity_temoperature", p_thermal_param->cavity_tempera);
	cJSON_AddNumberToObject(p_json_root, "is_display_al_area", p_thermal_param->is_display_al_area);
	cJSON_AddNumberToObject(p_json_root, "temperature_unit", p_thermal_param->tempera_unit);
	cJSON_AddNumberToObject(p_json_root, "distance", p_thermal_param->distance);
	cJSON_AddNumberToObject(p_json_root, "threshold", p_thermal_param->threshold);
	cJSON_AddNumberToObject(p_json_root, "alarm_int", p_thermal_param->alarm_int);
	cJSON_AddNumberToObject(p_json_root, "ave_temperature_correction", p_thermal_param->ave_tempera_corre);
	cJSON_AddNumberToObject(p_json_root, "abnormal_temperature_filter", p_thermal_param->abnormal_tempera_filter);
	cJSON_AddNumberToObject(p_json_root, "measure_mode", p_thermal_param->measure_mode);
	cJSON_AddNumberToObject(p_json_root, "alarm_delay", p_thermal_param->alarm_delay);
	cJSON_AddNumberToObject(p_json_root, "drc_mode", p_thermal_param->drc_mode);
	cJSON_AddNumberToObject(p_json_root, "manual_drcmode_rangeid", p_thermal_param->manual_drc_id);
	cJSON_AddNumberToObject(p_json_root, "manual_drcmode_range_max", p_thermal_param->manual_drc_range_max);
	cJSON_AddNumberToObject(p_json_root, "manual_drcmode_range_min", p_thermal_param->manual_drc_range_min);
	cJSON_AddNumberToObject(p_json_root, "manual_drcmode_ori_max", p_thermal_param->manual_drc_ori_max);
	cJSON_AddNumberToObject(p_json_root, "manual_drcmode_ori_min", p_thermal_param->manual_drc_ori_min);
	cJSON_AddNumberToObject(p_json_root, "measure_rangeid", p_thermal_param->measure_rangeid);
	cJSON_AddNumberToObject(p_json_root, "osd_fontcolor_r", p_thermal_param->osd_fontcolor_r);
	cJSON_AddNumberToObject(p_json_root, "osd_fontcolor_g", p_thermal_param->osd_fontcolor_g);
	cJSON_AddNumberToObject(p_json_root, "osd_fontcolor_b", p_thermal_param->osd_fontcolor_b);
	cJSON_AddNumberToObject(p_json_root, "large_enable", p_thermal_param->large_enable);
	cJSON_AddNumberToObject(p_json_root, "large_temoperature", p_thermal_param->large_tempera);
	cJSON_AddNumberToObject(p_json_root, "largecolor_r", p_thermal_param->largecolor_r);
	cJSON_AddNumberToObject(p_json_root, "largecolor_g", p_thermal_param->largecolor_g);
	cJSON_AddNumberToObject(p_json_root, "largecolor_b", p_thermal_param->largecolor_b);
	cJSON_AddNumberToObject(p_json_root, "range_enable", p_thermal_param->range_enable);
	cJSON_AddNumberToObject(p_json_root, "range_min_temoperature", p_thermal_param->range_min_tempera);
	cJSON_AddNumberToObject(p_json_root, "range_max_temoperature", p_thermal_param->range_max_tempera);
	cJSON_AddNumberToObject(p_json_root, "range_color_r", p_thermal_param->range_color_r);
	cJSON_AddNumberToObject(p_json_root, "range_color_g", p_thermal_param->range_color_g);
	cJSON_AddNumberToObject(p_json_root, "range_color_b", p_thermal_param->range_color_b);
	cJSON_AddNumberToObject(p_json_root, "small_enable", p_thermal_param->small_enable);
	cJSON_AddNumberToObject(p_json_root, "small_temoperature", p_thermal_param->small_tempera);
	cJSON_AddNumberToObject(p_json_root, "small_color_r", p_thermal_param->small_color_r);
	cJSON_AddNumberToObject(p_json_root, "small_color_g", p_thermal_param->small_color_g);
	cJSON_AddNumberToObject(p_json_root, "small_color_b", p_thermal_param->small_color_b);
	cJSON_AddNumberToObject(p_json_root, "mix_stream_mode", p_thermal_param->mix_stream_mode);
	cJSON_AddNumberToObject(p_json_root, "raw_upload_interval", p_thermal_param->raw_upload_interval);
	cJSON_AddNumberToObject(p_json_root, "prevent_overheat_mode", p_thermal_param->prevent_overheat_mode);
	cJSON_AddNumberToObject(p_json_root, "keepclose_duration", p_thermal_param->keepclose_duration);
	cJSON_AddNumberToObject(p_json_root, "control_cover", p_thermal_param->control_cover);
	cJSON_AddNumberToObject(p_json_root, "NormalTemperatureRange_Max", p_thermal_param->normal_temp_range_max);
	cJSON_AddNumberToObject(p_json_root, "NormalTemperatureRange_Min", p_thermal_param->normal_temp_range_min);
	cJSON_AddNumberToObject(p_json_root, "LengthUnit", p_thermal_param->length_unit);
	cJSON_AddNumberToObject(p_json_root, "TempAreaMode", p_thermal_param->temp_area_mode);
	*p_param = cJSON_PrintUnformatted(p_json_root);
	cJSON_Delete(p_json_root);
}

void pack_json_thermal_area_param(jy_dev_thermal_area_tempera_param_t *p_thermal_area_param, char **p_param)
{
	if ((NULL == p_thermal_area_param) || (NULL == p_param))
	{
		return;
	}
	*p_param = NULL;
	cJSON *p_json_root = cJSON_CreateObject();
	cJSON_AddNumberToObject(p_json_root, "chn_id", p_thermal_area_param->chn_id);
	cJSON_AddNumberToObject(p_json_root, "area_oper_type", p_thermal_area_param->area_oper_type);
	cJSON_AddNumberToObject(p_json_root, "value", p_thermal_area_param->value);
	cJSON *p_area_list = cJSON_CreateArray();
	for (int i = 0; i < p_thermal_area_param->area_size; ++i)
	{
		cJSON *p_area = cJSON_CreateObject();
		cJSON_AddNumberToObject(p_area, "area_id", p_thermal_area_param->area_id_list[i].area_id);
		cJSON_AddItemToArray(p_area_list, p_area);
	}
	cJSON_AddItemToObject(p_json_root, "area_list", p_area_list);
	*p_param = cJSON_PrintUnformatted(p_json_root);
	cJSON_Delete(p_json_root);
}

static void pack_area_point_info(jy_dev_area_point_list_t *p_area_point_list, char *str_area_point)
{
	int area_size = 0;
	char point_info[32] = { 0 };
	if (p_area_point_list->list_size > 0)
	{
		if (1 == p_area_point_list->list_size)
		{
			sprintf(str_area_point, "(%lf, %lf)", p_area_point_list->area_point[0].point_x, p_area_point_list->area_point[0].point_y);
		}
		else
		{
			sprintf(str_area_point, "(%lf, %lf)", p_area_point_list->area_point[0].point_x, p_area_point_list->area_point[0].point_y);
			area_size = strlen(str_area_point);
			for (int i = 1; i < p_area_point_list->list_size; ++i)
			{
				sprintf(point_info, ";(%lf, %lf)", p_area_point_list->area_point[i].point_x, p_area_point_list->area_point[i].point_y);
				strcpy(str_area_point + area_size, point_info);
				area_size += strlen(point_info);
			}
		}
	}
}

void pack_json_thermal_area_measure(jy_dev_thermal_area_measure_t *p_thermal_area_measure, char **p_param)
{
	if (NULL == p_thermal_area_measure || NULL == p_param)
	{
		return;
	}
	*p_param = NULL;
	char str_area_point[1024] = { 0 };
	cJSON* p_json_root = cJSON_CreateObject();
	cJSON_AddNumberToObject(p_json_root, "area_oper_type", p_thermal_area_measure->area_oper_type);
	cJSON_AddNumberToObject(p_json_root, "channel", p_thermal_area_measure->chn_id);
	cJSON_AddNumberToObject(p_json_root, "measure_mode", p_thermal_area_measure->measure_mode);
	cJSON_AddNumberToObject(p_json_root, "preset_id", p_thermal_area_measure->preset_id);
	cJSON* p_temp_area_list = cJSON_CreateArray();
	for (int i = 0; i < p_thermal_area_measure->area_size; i++)
	{
		cJSON* p_temp = cJSON_CreateObject();
		cJSON_AddNumberToObject(p_temp, "area_id", p_thermal_area_measure->area_info_list[i].area_id);
		cJSON_AddStringToObject(p_temp, "area_name", p_thermal_area_measure->area_info_list[i].area_name);
		cJSON_AddNumberToObject(p_temp, "alarm_en", p_thermal_area_measure->area_info_list[i].alarm_enable_flag);
		cJSON_AddNumberToObject(p_temp, "alarm_type", p_thermal_area_measure->area_info_list[i].alarm_type);
		cJSON_AddNumberToObject(p_temp, "warning_alarm_value", p_thermal_area_measure->area_info_list[i].warning_alarm_value);
		cJSON_AddNumberToObject(p_temp, "alarm_max_value", p_thermal_area_measure->area_info_list[i].alarm_max_value);
		cJSON_AddNumberToObject(p_temp, "alarm_value", p_thermal_area_measure->area_info_list[i].alarm_value);
		cJSON_AddNumberToObject(p_temp, "emissivity", p_thermal_area_measure->area_info_list[i].emissivity);
		cJSON_AddNumberToObject(p_temp, "target_space", p_thermal_area_measure->area_info_list[i].target_space);
		cJSON_AddNumberToObject(p_temp, "area_en_flag", p_thermal_area_measure->area_info_list[i].area_en_flag);
		cJSON_AddNumberToObject(p_temp, "area_shape_type", p_thermal_area_measure->area_info_list[i].area_shape_type);
		pack_area_point_info(&p_thermal_area_measure->area_info_list[i].area_point_list, str_area_point);
		cJSON_AddStringToObject(p_temp, "point_coor_list", str_area_point);
		cJSON_AddItemToArray(p_temp_area_list, p_temp);
	}
	cJSON_AddItemToObject(p_json_root, "area_list", p_temp_area_list);
	*p_param = cJSON_PrintUnformatted(p_json_root);
	cJSON_Delete(p_json_root);
}

void pack_json_disk_alarm(jy_dev_disk_alarm_param_list_t *p_disk_alarm, char **p_param)
{
	if (NULL == p_disk_alarm || NULL == p_param)
	{
		return;
	}
	*p_param = NULL;
	cJSON* p_json_root = cJSON_CreateObject();
	cJSON* p_json_disk_alarm_list = cJSON_CreateArray();
	for (int i = 0; i < p_disk_alarm->num; ++i)
	{
		cJSON* p_json_disk_alarm_event = cJSON_CreateObject();
		cJSON* p_json_disk_source_para = cJSON_CreateObject();
		cJSON_AddNumberToObject(p_json_disk_source_para, "src_type", p_disk_alarm->disk_param_list[i].source_type);
		cJSON_AddNumberToObject(p_json_disk_source_para, "src_id", p_disk_alarm->disk_param_list[i].source_id);
		cJSON_AddStringToObject(p_json_disk_source_para, "src_name", p_disk_alarm->disk_param_list[i].source_name);
		cJSON_AddNumberToObject(p_json_disk_source_para, "enable", p_disk_alarm->disk_param_list[i].enable);
		cJSON_AddNumberToObject(p_json_disk_source_para, "alarm_inval", p_disk_alarm->disk_param_list[i].alarm_interval);
		cJSON_AddNumberToObject(p_json_disk_source_para, "disk_full_flag", p_disk_alarm->disk_param_list[i].full_alarm_enable);
		cJSON_AddNumberToObject(p_json_disk_source_para, "threshold", p_disk_alarm->disk_param_list[i].alarm_threshold);
		cJSON_AddNumberToObject(p_json_disk_source_para, "disk_error_flag", p_disk_alarm->disk_param_list[i].error_alarm_enable);
		cJSON_AddNumberToObject(p_json_disk_source_para, "no_disk_alarm_flag", p_disk_alarm->disk_param_list[i].no_disk_alarm_enable);

		cJSON* p_json_schedule_time_list = cJSON_CreateArray();
		for (int j = 0; j <  p_disk_alarm->disk_param_list[i].schedule_time_size; ++j)
		{
			cJSON* p_json_schedule_time = cJSON_CreateObject();
			cJSON_AddNumberToObject(p_json_schedule_time, "weekday", p_disk_alarm->disk_param_list[i].schedule_time_list[j].week_day);
			cJSON_AddNumberToObject(p_json_schedule_time, "sTime", p_disk_alarm->disk_param_list[i].schedule_time_list[j].start_time);
			cJSON_AddNumberToObject(p_json_schedule_time, "eTime", p_disk_alarm->disk_param_list[i].schedule_time_list[j].end_time);
			cJSON_AddItemToArray(p_json_schedule_time_list, p_json_schedule_time);
		}
		cJSON_AddItemToObject(p_json_disk_source_para, "time_list", p_json_schedule_time_list);
		cJSON_AddItemToObject(p_json_disk_alarm_event, "alarm_source_para", p_json_disk_source_para);

		cJSON* p_json_link_para_list = cJSON_CreateArray();
		for (int j = 0; j < p_disk_alarm->disk_param_list[i].alarm_linkage_size; ++j)
		{
			cJSON* p_json_link_para = cJSON_CreateObject();
			cJSON_AddNumberToObject(p_json_link_para, "act_type", p_disk_alarm->disk_param_list[i].alarm_linkage_list[j].action_type);
			cJSON_AddNumberToObject(p_json_link_para, "act_id", p_disk_alarm->disk_param_list[i].alarm_linkage_list[j].action_id);
			cJSON_AddItemToArray(p_json_link_para_list, p_json_link_para);
		}
		cJSON_AddItemToObject(p_json_disk_alarm_event, "linkage_para_list", p_json_link_para_list);

		cJSON* p_json_ptz_para_list = cJSON_CreateArray();
		for (int j = 0; j < p_disk_alarm->disk_param_list[i].ptz_action_size; ++j)
		{
			cJSON* p_json_ptz_para = cJSON_CreateObject();
			cJSON_AddNumberToObject(p_json_ptz_para, "act_type", p_disk_alarm->disk_param_list[i].ptz_action_param_list[j].action_type);
			cJSON_AddNumberToObject(p_json_ptz_para, "act_id", p_disk_alarm->disk_param_list[i].ptz_action_param_list[j].action_id);
			cJSON_AddStringToObject(p_json_ptz_para, "act_name", p_disk_alarm->disk_param_list[i].ptz_action_param_list[j].action_name);
			cJSON_AddNumberToObject(p_json_ptz_para, "ptz_act_type", p_disk_alarm->disk_param_list[i].ptz_action_param_list[j].ptz_action_type);
			cJSON_AddNumberToObject(p_json_ptz_para, "ptz_act_id", p_disk_alarm->disk_param_list[i].ptz_action_param_list[j].ptz_action_id);
			cJSON_AddNumberToObject(p_json_ptz_para, "ptz_channel_id", p_disk_alarm->disk_param_list[i].ptz_action_param_list[j].ptz_chn_id);
			cJSON_AddItemToArray(p_json_ptz_para_list, p_json_ptz_para);
		}
		cJSON_AddItemToObject(p_json_disk_alarm_event, "ptz_action_para_list", p_json_ptz_para_list);

		cJSON* p_json_alarm_out_para_list = cJSON_CreateArray();
		for (int j = 0; j < p_disk_alarm->disk_param_list[i].alarm_out_size; ++j)
		{
			cJSON* p_json_alarm_out_para = cJSON_CreateObject();
			cJSON_AddNumberToObject(p_json_alarm_out_para, "act_type", p_disk_alarm->disk_param_list[i].alarm_out_list[j].action_type);
			cJSON_AddNumberToObject(p_json_alarm_out_para, "act_id", p_disk_alarm->disk_param_list[i].alarm_out_list[j].action_id);
			cJSON_AddStringToObject(p_json_alarm_out_para, "act_name", p_disk_alarm->disk_param_list[i].alarm_out_list[j].action_name);
			cJSON_AddStringToObject(p_json_alarm_out_para, "dev_id", p_disk_alarm->disk_param_list[i].alarm_out_list[j].device_id);
			cJSON_AddNumberToObject(p_json_alarm_out_para, "alarm_out_id", p_disk_alarm->disk_param_list[i].alarm_out_list[j].alarm_out_id);
			cJSON_AddNumberToObject(p_json_alarm_out_para, "alarm_out_flag", p_disk_alarm->disk_param_list[i].alarm_out_list[j].alarm_out_flag);
			cJSON_AddNumberToObject(p_json_alarm_out_para, "event_type_id", p_disk_alarm->disk_param_list[i].alarm_out_list[j].event_type_id);
			cJSON_AddNumberToObject(p_json_alarm_out_para, "alarm_time", p_disk_alarm->disk_param_list[i].alarm_out_list[j].alarm_time);
			cJSON_AddItemToArray(p_json_alarm_out_para_list, p_json_alarm_out_para);
		}
		cJSON_AddItemToObject(p_json_disk_alarm_event, "alarm_out_action_para_list", p_json_alarm_out_para_list);

		cJSON_AddItemToArray(p_json_disk_alarm_list, p_json_disk_alarm_event);
	}
	cJSON_AddItemToObject(p_json_root, "disk_alarm_list", p_json_disk_alarm_list);
	*p_param = cJSON_PrintUnformatted(p_json_root);
	cJSON_Delete(p_json_root);
}

void pack_json_io_alarm(jy_dev_io_alarm_param_list_t *p_io_alarm, char **p_param)
{
	if (NULL == p_io_alarm || NULL == p_param)
	{
		return;
	}
	*p_param = NULL;
	cJSON* p_json_root = cJSON_CreateObject();
	cJSON* p_json_io_alarm_list = cJSON_CreateArray();
	for (int i = 0; i < p_io_alarm->num; ++i)
	{
		cJSON* p_json_io_alarm_event = cJSON_CreateObject();
		cJSON* p_json_io_source_para = cJSON_CreateObject();
		cJSON_AddNumberToObject(p_json_io_source_para, "src_type", p_io_alarm->io_param_list[i].source_type);
		cJSON_AddNumberToObject(p_json_io_source_para, "src_id", p_io_alarm->io_param_list[i].source_id);
		cJSON_AddStringToObject(p_json_io_source_para, "src_name", p_io_alarm->io_param_list[i].source_name);
		cJSON_AddNumberToObject(p_json_io_source_para, "enable", p_io_alarm->io_param_list[i].enable);
		cJSON_AddNumberToObject(p_json_io_source_para, "alarm_inval", p_io_alarm->io_param_list[i].alarm_interval);
		cJSON_AddNumberToObject(p_json_io_source_para, "valid_level", p_io_alarm->io_param_list[i].valid_level);

		cJSON* p_json_schedule_time_list = cJSON_CreateArray();
		for (int j = 0; j < p_io_alarm->io_param_list[i].schedule_time_size; ++j)
		{
			cJSON* p_json_schedule_time = cJSON_CreateObject();
			cJSON_AddNumberToObject(p_json_schedule_time, "weekday", p_io_alarm->io_param_list[i].schedule_time_list[j].week_day);
			cJSON_AddNumberToObject(p_json_schedule_time, "sTime", p_io_alarm->io_param_list[i].schedule_time_list[j].start_time);
			cJSON_AddNumberToObject(p_json_schedule_time, "eTime", p_io_alarm->io_param_list[i].schedule_time_list[j].end_time);
			cJSON_AddItemToArray(p_json_schedule_time_list, p_json_schedule_time);
		}
		cJSON_AddItemToObject(p_json_io_source_para, "time_list", p_json_schedule_time_list);
		cJSON_AddItemToObject(p_json_io_alarm_event, "insource_para", p_json_io_source_para);

		cJSON* p_json_link_para_list = cJSON_CreateArray();
		for (int j = 0; j < p_io_alarm->io_param_list[i].alarm_linkage_size; ++j)
		{
			cJSON* p_json_link_para = cJSON_CreateObject();
			cJSON_AddNumberToObject(p_json_link_para, "act_type", p_io_alarm->io_param_list[i].alarm_linkage_list[j].action_type);
			cJSON_AddNumberToObject(p_json_link_para, "act_id", p_io_alarm->io_param_list[i].alarm_linkage_list[j].action_id);
			cJSON_AddItemToArray(p_json_link_para_list, p_json_link_para);
		}
		cJSON_AddItemToObject(p_json_io_alarm_event, "linkage_para_list", p_json_link_para_list);

		cJSON* p_json_ptz_para_list = cJSON_CreateArray();
		for (int j = 0; j < p_io_alarm->io_param_list[i].ptz_action_size; ++j)
		{
			cJSON* p_json_ptz_para = cJSON_CreateObject();
			cJSON_AddNumberToObject(p_json_ptz_para, "act_type", p_io_alarm->io_param_list[i].ptz_action_param_list[j].action_type);
			cJSON_AddNumberToObject(p_json_ptz_para, "act_id", p_io_alarm->io_param_list[i].ptz_action_param_list[j].action_id);
			cJSON_AddStringToObject(p_json_ptz_para, "act_name", p_io_alarm->io_param_list[i].ptz_action_param_list[j].action_name);
			cJSON_AddNumberToObject(p_json_ptz_para, "ptz_act_type", p_io_alarm->io_param_list[i].ptz_action_param_list[j].ptz_action_type);
			cJSON_AddNumberToObject(p_json_ptz_para, "ptz_act_id", p_io_alarm->io_param_list[i].ptz_action_param_list[j].ptz_action_id);
			cJSON_AddNumberToObject(p_json_ptz_para, "ptz_channel_id", p_io_alarm->io_param_list[i].ptz_action_param_list[j].ptz_chn_id);
			cJSON_AddItemToArray(p_json_ptz_para_list, p_json_ptz_para);
		}
		cJSON_AddItemToObject(p_json_io_alarm_event, "ptz_action_para_list", p_json_ptz_para_list);

		cJSON* p_json_alarm_out_para_list = cJSON_CreateArray();
		for (int j = 0; j < p_io_alarm->io_param_list[i].alarm_out_size; ++j)
		{
			cJSON* p_json_alarm_out_para = cJSON_CreateObject();
			cJSON_AddNumberToObject(p_json_alarm_out_para, "act_type", p_io_alarm->io_param_list[i].alarm_out_list[j].action_type);
			cJSON_AddNumberToObject(p_json_alarm_out_para, "act_id", p_io_alarm->io_param_list[i].alarm_out_list[j].action_id);
			cJSON_AddStringToObject(p_json_alarm_out_para, "act_name", p_io_alarm->io_param_list[i].alarm_out_list[j].action_name);
			cJSON_AddStringToObject(p_json_alarm_out_para, "dev_id", p_io_alarm->io_param_list[i].alarm_out_list[j].device_id);
			cJSON_AddNumberToObject(p_json_alarm_out_para, "event_type_id", p_io_alarm->io_param_list[i].alarm_out_list[j].alarm_out_id);
			cJSON_AddNumberToObject(p_json_alarm_out_para, "alarm_out_flag", p_io_alarm->io_param_list[i].alarm_out_list[j].alarm_out_flag);
			cJSON_AddNumberToObject(p_json_alarm_out_para, "event_type_id", p_io_alarm->io_param_list[i].alarm_out_list[j].event_type_id);
			cJSON_AddNumberToObject(p_json_alarm_out_para, "alarm_time", p_io_alarm->io_param_list[i].alarm_out_list[j].alarm_time);
			cJSON_AddItemToArray(p_json_alarm_out_para_list, p_json_alarm_out_para);
		}
		cJSON_AddItemToObject(p_json_io_alarm_event, "alarm_out_action_para_list", p_json_alarm_out_para_list);

		cJSON* p_json_recode_list = cJSON_CreateArray();
		for (int j = 0; j < p_io_alarm->io_param_list[i].record_param_size; ++j)
		{
			cJSON* p_json_recode_para = cJSON_CreateObject();
			cJSON_AddNumberToObject(p_json_recode_para, "act_type", p_io_alarm->io_param_list[i].record_param_list[j].action_type);
			cJSON_AddNumberToObject(p_json_recode_para, "act_id", p_io_alarm->io_param_list[i].record_param_list[j].action_id);
			cJSON_AddStringToObject(p_json_recode_para, "act_name", p_io_alarm->io_param_list[i].record_param_list[j].action_name);
			cJSON_AddNumberToObject(p_json_recode_para, "pre_record_flag", p_io_alarm->io_param_list[i].record_param_list[j].pre_record_flag);
			cJSON_AddNumberToObject(p_json_recode_para, "delay_time", p_io_alarm->io_param_list[i].record_param_list[j].delay_record_time);
			cJSON_AddItemToArray(p_json_recode_list, p_json_recode_para);
		}
		cJSON_AddItemToObject(p_json_io_alarm_event, "record_action_para_list", p_json_recode_list);

		cJSON_AddItemToArray(p_json_io_alarm_list, p_json_io_alarm_event);
	}
	cJSON_AddItemToObject(p_json_root, "alarm_event_list", p_json_io_alarm_list);
	*p_param = cJSON_PrintUnformatted(p_json_root);
	cJSON_Delete(p_json_root);
}

void pack_json_mot_alarm(jy_dev_mot_alarm_param_list_t *p_mot_alarm, char **p_param)
{
	if (NULL == p_mot_alarm)
	{
		return;
	}
	*p_param = NULL;
	cJSON* p_root = cJSON_CreateObject();
	cJSON_AddNumberToObject(p_root, "enable", p_mot_alarm->mot_alarm_list[0].mot_source_param.enable_flag);
	cJSON_AddNumberToObject(p_root, "alarmval", p_mot_alarm->mot_alarm_list[0].mot_source_param.alarm_interval);
	cJSON_AddNumberToObject(p_root, "blocknum", p_mot_alarm->mot_alarm_list[0].mot_source_param.mot_detect_param.check_block_num);
	cJSON_AddNumberToObject(p_root, "sensitivity", p_mot_alarm->mot_alarm_list[0].mot_source_param.mot_detect_param.sensitivity);
	cJSON_AddNumberToObject(p_root, "widthnum", p_mot_alarm->mot_alarm_list[0].mot_source_param.mot_detect_param.detect_area.width_cell_number);
	cJSON_AddNumberToObject(p_root, "highnum", p_mot_alarm->mot_alarm_list[0].mot_source_param.mot_detect_param.detect_area.high_cell_number);
	cJSON_AddStringToObject(p_root, "areadata", p_mot_alarm->mot_alarm_list[0].mot_source_param.mot_detect_param.detect_area.date);
	cJSON* p_time_list = cJSON_CreateArray();
	for (int i = 0; i < p_mot_alarm->mot_alarm_list[0].mot_source_param.schedule_time_size; i++)
	{
		cJSON* p_alarm_time_item = cJSON_CreateObject();
		cJSON_AddNumberToObject(p_alarm_time_item, "weekday", p_mot_alarm->mot_alarm_list[0].mot_source_param.schedule_time_list[i].week_day);
		cJSON_AddNumberToObject(p_alarm_time_item, "sTime", p_mot_alarm->mot_alarm_list[0].mot_source_param.schedule_time_list[i].start_time);
		cJSON_AddNumberToObject(p_alarm_time_item, "eTime", p_mot_alarm->mot_alarm_list[0].mot_source_param.schedule_time_list[i].end_time);
		cJSON_AddItemToArray(p_time_list, p_alarm_time_item);
	}
	cJSON_AddItemToObject(p_root, "timelist", p_time_list);
	*p_param = cJSON_PrintUnformatted(p_root);
	cJSON_Delete(p_root);
}
/*
void pack_json_mot_alarm(jy_dev_mot_alarm_param_list_t *p_mot_alarm, char **p_param)
{
	if (NULL == p_mot_alarm)
	{
		return;
	}
	*p_param = NULL;
	cJSON* p_root = cJSON_CreateObject();
	cJSON* p_mot_detect_event_list = cJSON_CreateArray();
	cJSON_AddItemToObject(p_root, "MotionDetectEventList", p_mot_detect_event_list);
	for (int i = 0; i < p_mot_alarm->num; i++)
	{
		cJSON* p_mot_detect_event = cJSON_CreateObject();
		cJSON* p_mot_detect_source = cJSON_CreateObject();
		cJSON_AddNumberToObject(p_mot_detect_source, "SourceType", p_mot_alarm->mot_alarm_list[i].mot_source_param.source_type);
		cJSON_AddNumberToObject(p_mot_detect_source, "SourceID", p_mot_alarm->mot_alarm_list[i].mot_source_param.source_id);
		cJSON_AddStringToObject(p_mot_detect_source, "SourceName", p_mot_alarm->mot_alarm_list[i].mot_source_param.source_name);
		cJSON_AddNumberToObject(p_mot_detect_source, "EnableFlag", p_mot_alarm->mot_alarm_list[i].mot_source_param.enable_flag);
		cJSON_AddNumberToObject(p_mot_detect_source, "AlarmInterval", p_mot_alarm->mot_alarm_list[i].mot_source_param.alarm_interval);
		cJSON_AddNumberToObject(p_mot_detect_source, "MotionAnalysisFlag", p_mot_alarm->mot_alarm_list[i].mot_source_param.mot_analysis_flag);

		cJSON* p_alarm_time = cJSON_CreateObject();
		cJSON* p_alarm_time_list = cJSON_CreateArray();
		for (int j = 0; j < p_mot_alarm->mot_alarm_list[i].mot_source_param.schedule_time_size; j++)
		{
			cJSON* p_alarm_time_item = cJSON_CreateObject();
			cJSON_AddNumberToObject(p_alarm_time_item, "WeekDay", p_mot_alarm->mot_alarm_list[i].mot_source_param.schedule_time_list[j].week_day);
			cJSON_AddNumberToObject(p_alarm_time_item, "StartTime", p_mot_alarm->mot_alarm_list[i].mot_source_param.schedule_time_list[j].start_time);
			cJSON_AddNumberToObject(p_alarm_time_item, "EndTime", p_mot_alarm->mot_alarm_list[i].mot_source_param.schedule_time_list[j].end_time);
			cJSON_AddItemToArray(p_alarm_time_list, p_alarm_time_item);
		}
		cJSON_AddItemToObject(p_alarm_time, "ScheduleTimeList", p_alarm_time_list);
		cJSON_AddItemToObject(p_mot_detect_source, "AlarmTime", p_alarm_time);

		cJSON* p_mot_detect_param = cJSON_CreateObject();
		cJSON_AddNumberToObject(p_mot_detect_param, "CheckBlockNum", p_mot_alarm->mot_alarm_list[i].mot_source_param.mot_detect_param.check_block_num);
		cJSON_AddNumberToObject(p_mot_detect_param, "Sensitivity", p_mot_alarm->mot_alarm_list[i].mot_source_param.mot_detect_param.sensitivity);
		cJSON* p_mot_detect_area = cJSON_CreateObject();
		cJSON_AddNumberToObject(p_mot_detect_area, "WidthCellNumber", p_mot_alarm->mot_alarm_list[i].mot_source_param.mot_detect_param.detect_area.width_cell_number);
		cJSON_AddNumberToObject(p_mot_detect_area, "HighCellNumber", p_mot_alarm->mot_alarm_list[i].mot_source_param.mot_detect_param.detect_area.high_cell_number);
		cJSON_AddNumberToObject(p_mot_detect_area, "DataLength", p_mot_alarm->mot_alarm_list[i].mot_source_param.mot_detect_param.detect_area.data_length);
		cJSON_AddStringToObject(p_mot_detect_area, "Data", p_mot_alarm->mot_alarm_list[i].mot_source_param.mot_detect_param.detect_area.date);
		cJSON_AddItemToObject(p_mot_detect_param, "DetectionArea", p_mot_detect_area);
		cJSON_AddItemToObject(p_mot_detect_source, "MotionDetectionParam", p_mot_detect_param);
		cJSON_AddItemToObject(p_mot_detect_event, "MotionDetectSource", p_mot_detect_source);

		cJSON* p_alarm_link_list = cJSON_CreateArray();
		for (int n = 0; n < p_mot_alarm->mot_alarm_list[i].alarm_linkage_size; n++)
		{
			cJSON* p_alarm_link_param = cJSON_CreateObject();
			cJSON_AddNumberToObject(p_alarm_link_param, "ActionType", p_mot_alarm->mot_alarm_list[i].alarm_linkage_list[n].action_type);
			cJSON_AddNumberToObject(p_alarm_link_param, "ActionID", p_mot_alarm->mot_alarm_list[i].alarm_linkage_list[n].action_id);
			cJSON_AddItemToArray(p_alarm_link_list, p_alarm_link_param);
		}
		cJSON_AddItemToObject(p_mot_detect_event, "AlarmLinkageParamList", p_alarm_link_list);


		cJSON* p_ptz_action_param_list = cJSON_CreateArray();
		for (int m = 0; m < p_mot_alarm->mot_alarm_list[i].ptz_action_size; m++)
		{
			cJSON* p_ptz_action_param = cJSON_CreateObject();
			cJSON_AddNumberToObject(p_ptz_action_param, "ActionType", p_mot_alarm->mot_alarm_list[i].ptz_action_param_list[m].action_type);
			cJSON_AddNumberToObject(p_ptz_action_param, "ActionID", p_mot_alarm->mot_alarm_list[i].ptz_action_param_list[m].action_id);
			cJSON_AddStringToObject(p_ptz_action_param, "ActionName", p_mot_alarm->mot_alarm_list[i].ptz_action_param_list[m].action_name);
			cJSON_AddNumberToObject(p_ptz_action_param, "PTZActionType", p_mot_alarm->mot_alarm_list[i].ptz_action_param_list[m].ptz_action_type);
			cJSON_AddNumberToObject(p_ptz_action_param, "PTZActionID", p_mot_alarm->mot_alarm_list[i].ptz_action_param_list[m].ptz_action_id);
			cJSON_AddNumberToObject(p_ptz_action_param, "PTZChannelID", p_mot_alarm->mot_alarm_list[i].ptz_action_param_list[m].ptz_chn_id);
			cJSON_AddItemToArray(p_ptz_action_param_list, p_ptz_action_param);
		}
		cJSON_AddItemToObject(p_mot_detect_event, "PTZActionParamList", p_ptz_action_param_list);

		cJSON* p_alarm_out_action_list = cJSON_CreateArray();
		for (int j = 0; j < p_mot_alarm->mot_alarm_list[i].alarm_out_size; j++)
		{
			cJSON* p_alarm_out_action = cJSON_CreateObject();
			cJSON_AddNumberToObject(p_alarm_out_action, "ActionType", p_mot_alarm->mot_alarm_list[i].alarm_out_list[j].action_type);
			cJSON_AddNumberToObject(p_alarm_out_action, "ActionID", p_mot_alarm->mot_alarm_list[i].alarm_out_list[j].action_id);
			cJSON_AddStringToObject(p_alarm_out_action, "ActionName", p_mot_alarm->mot_alarm_list[i].alarm_out_list[j].action_name);
			cJSON_AddStringToObject(p_alarm_out_action, "DeviceId", p_mot_alarm->mot_alarm_list[i].alarm_out_list[j].device_id);
			cJSON_AddNumberToObject(p_alarm_out_action, "AlarmOutId", p_mot_alarm->mot_alarm_list[i].alarm_out_list[j].alarm_out_id);
			cJSON_AddNumberToObject(p_alarm_out_action, "AlarmOutFlag", p_mot_alarm->mot_alarm_list[i].alarm_out_list[j].alarm_out_flag);
			cJSON_AddNumberToObject(p_alarm_out_action, "EventTypeId", p_mot_alarm->mot_alarm_list[i].alarm_out_list[j].event_type_id);
			cJSON_AddNumberToObject(p_alarm_out_action, "AlarmTime", p_mot_alarm->mot_alarm_list[i].alarm_out_list[j].alarm_time);
			cJSON_AddItemToArray(p_alarm_out_action_list, p_alarm_out_action);
		}
		cJSON_AddItemToObject(p_mot_detect_event, "AlarmOutActionList", p_alarm_out_action_list);

		cJSON* p_record_action_list = cJSON_CreateArray();
		for (int k = 0; k < p_mot_alarm->mot_alarm_list[i].record_param_size; k++)
		{
			cJSON* p_record_action_param = cJSON_CreateObject();
			cJSON_AddNumberToObject(p_record_action_param, "ActionType", p_mot_alarm->mot_alarm_list[i].record_param_list[k].action_type);
			cJSON_AddNumberToObject(p_record_action_param, "ActionID", p_mot_alarm->mot_alarm_list[i].record_param_list[k].action_id);
			cJSON_AddStringToObject(p_record_action_param, "ActionName", p_mot_alarm->mot_alarm_list[i].record_param_list[k].action_name);
			cJSON_AddNumberToObject(p_record_action_param, "PreRecordFlag", p_mot_alarm->mot_alarm_list[i].record_param_list[k].pre_record_flag);
			cJSON_AddNumberToObject(p_record_action_param, "DelayRecordTime", p_mot_alarm->mot_alarm_list[i].record_param_list[k].delay_record_time);
			cJSON_AddItemToArray(p_record_action_list, p_record_action_param);
		}
		cJSON_AddItemToObject(p_mot_detect_event, "RecordActionParamList", p_record_action_list);

		cJSON_AddItemToArray(p_mot_detect_event_list, p_mot_detect_event);
	}

	*p_param = cJSON_PrintUnformatted(p_root);
	cJSON_Delete(p_root);
}
*/
void pack_json_record_policy(jy_dev_record_policy_list_t *p_record_policy, char **p_param)
{
	if (NULL == p_record_policy)
	{
		return;
	}
	*p_param = NULL;
	cJSON* p_root = cJSON_CreateObject();
	cJSON* p_record_policy_list = cJSON_CreateArray();
	cJSON_AddItemToObject(p_root, "record_policy_list", p_record_policy_list);
	for (int i = 0; i < p_record_policy->num; i++)
	{
		cJSON* p_rec_policy = cJSON_CreateObject();
		cJSON_AddNumberToObject(p_rec_policy, "record_flag", p_record_policy->record_policy_list[i].record_open_flag);
		cJSON_AddNumberToObject(p_rec_policy, "record_mode", p_record_policy->record_policy_list[i].record_mode);
		cJSON_AddStringToObject(p_rec_policy, "dev_id", p_record_policy->record_policy_list[i].dev_id);
		cJSON_AddNumberToObject(p_rec_policy, "channel_id", p_record_policy->record_policy_list[i].channel_id);
		cJSON_AddNumberToObject(p_rec_policy, "stream_id", p_record_policy->record_policy_list[i].stream_id);
		cJSON_AddNumberToObject(p_rec_policy, "save_days", p_record_policy->record_policy_list[i].save_days);
		cJSON_AddNumberToObject(p_rec_policy, "audio_flag", p_record_policy->record_policy_list[i].audio_open_flag);
		cJSON_AddNumberToObject(p_rec_policy, "disk_id", p_record_policy->record_policy_list[i].disk_id);
		cJSON* p_time_list = cJSON_CreateArray();
		for (int j = 0; j < p_record_policy->record_policy_list[i].schedule_time_size; j++)
		{
			cJSON* p_time_item = cJSON_CreateObject();
			cJSON_AddNumberToObject(p_time_item, "weekday", p_record_policy->record_policy_list[i].schedule_time_list[j].week_day);
			cJSON_AddNumberToObject(p_time_item, "sTime", p_record_policy->record_policy_list[i].schedule_time_list[j].start_time);
			cJSON_AddNumberToObject(p_time_item, "eTime", p_record_policy->record_policy_list[i].schedule_time_list[j].end_time);
			cJSON_AddItemToArray(p_time_list, p_time_item);
		}
		cJSON_AddItemToObject(p_rec_policy, "schedule_time_list", p_time_list);
		cJSON* p_snap_shot_para = cJSON_CreateObject();
		cJSON_AddNumberToObject(p_snap_shot_para, "duration", p_record_policy->record_policy_list[i].snap_shot_para.duration);
		cJSON_AddNumberToObject(p_snap_shot_para, "quality", p_record_policy->record_policy_list[i].snap_shot_para.quality);
		cJSON_AddNumberToObject(p_snap_shot_para, "interval", p_record_policy->record_policy_list[i].snap_shot_para.interval);
		cJSON_AddNumberToObject(p_snap_shot_para, "shoot_times", p_record_policy->record_policy_list[i].snap_shot_para.shoot_times);
		cJSON* p_video_solution = cJSON_CreateObject();
		cJSON_AddNumberToObject(p_video_solution, "video_height", p_record_policy->record_policy_list[i].snap_shot_para.video_solution.video_height);
		cJSON_AddNumberToObject(p_video_solution, "video_width", p_record_policy->record_policy_list[i].snap_shot_para.video_solution.video_width);
		cJSON_AddStringToObject(p_video_solution, "resolution_name", p_record_policy->record_policy_list[i].snap_shot_para.video_solution.resolution_name);
		cJSON_AddItemToObject(p_snap_shot_para, "video_resolution", p_video_solution);
		cJSON_AddItemToObject(p_rec_policy, "snap_shot_para", p_snap_shot_para);
		cJSON_AddItemToArray(p_record_policy_list, p_rec_policy);
	}
	*p_param = cJSON_PrintUnformatted(p_root);
	cJSON_Delete(p_root);
}